<?php

/**
 * Noptin Addons Pack
 *
 * Adds more features to Noptin.
 *
 * @since             1.0.0
 *
 * Plugin Name:     Noptin Addons Pack
 * Plugin URI:      https://noptin.com/product/ultimate-addons-pack
 * Description:     Adds more features to Noptin.
 * Author:          picocodes
 * Author URI:      https://github.com/picocodes
 * Version:         2.0.2
 * Text Domain:     noptin-addons-pack
 * License:         GPL3+
 * License URI:     http://www.gnu.org/licenses/gpl-3.0.txt
 * Domain Path:     /languages
 *
 * @author          Picocodes
 * @author          Kaz
 * @license         GNU General Public License, version 3
 * @copyright       Picocodes
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

define( 'NOPTIN_ADDONS_PACK_VERSION', '2.0.2' );
define( 'NOPTIN_ADDONS_PACK_FILE', __FILE__ );

/**
 * Loads the plugin after all plugins have loaded, to allow overides.
 *
 */
function noptin_addons_pack_load() {

	if ( function_exists( 'noptin' ) && version_compare( noptin()->version, '2.0.0', '>=' ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'vendor/autoload.php';
		require_once plugin_dir_path( __FILE__ ) . 'includes/loader.php';
	}
}
add_action( 'noptin_integrations_load', 'noptin_addons_pack_load' );

/**
 * Ask the site admin to install Noptin.
 */
function noptin_addons_pack_check_environment() {

	// Abort if the user can't install plugins.
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}

	// Or if the installed version is greater than the minimum supported version.
	if ( function_exists( 'noptin' ) && version_compare( noptin()->version, '2.0.0', '>=' ) ) {
		return;
	}

	// Print a notice with a thickbox link to the plugin installation page.
	?>
	<div class="notice notice-error">
		<p>
			<?php
				printf(
					/* translators:1 and 1 are opening and closing link. */
					esc_html__( 'Noptin Addons Pack requires Noptin version 2.0.0 or above to work. Please %1$sinstall or update%2$s Noptin.', 'noptin-addons-pack' ),
					'<a href="' . esc_url( admin_url( 'plugin-install.php?tab=plugin-information&plugin=newsletter-optin-box&TB_iframe=true&width=772&height=600' ) ) . '" class="thickbox" aria-label="Noptin" data-title="Noptin">',
					'</a>'
				);
			?>
		</p>
	</div>
	<?php

	add_thickbox();

}
add_action( 'admin_notices', 'noptin_addons_pack_check_environment', 100 );

/**
 * Load text domain.
 */
function noptin_addons_pack_load_plugin_textdomain() {

	load_plugin_textdomain(
		'noptin-addons-pack',
		false,
		'noptin-addons-pack/languages/'
	);

}
add_action( 'plugins_loaded', 'noptin_addons_pack_load_plugin_textdomain' );

/**
 * Register this as a premium addon.
 *
 * @param array $noptin_addons
 * @return array
 */
function noptin_addons_pack_register_premium_addon( $noptin_addons ) {

	$noptin_addons['noptin-addons-pack'] = 'Noptin Addons Pack';
	return $noptin_addons;
}
add_filter( 'noptin_premium_addons', 'noptin_addons_pack_register_premium_addon' );

/**
 * Maybe auto-install Noptin.
 */
function noptin_addons_pack_maybe_install_noptin() {

	// If Noptin is installed, return.
	if ( function_exists( 'noptin' ) ) {
		return;
	}

	// Abort if we've already tried to install it.
	$installed = get_option( 'noptin_connections_installed_noptin', 0 );

	if ( ! empty( $installed ) ) {
		return;
	}

	update_option( 'noptin_connections_installed_noptin', 1 );

	include_once ABSPATH . 'wp-admin/includes/file.php';
	include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
	include_once ABSPATH . 'wp-admin/includes/plugin.php';

	// If it is not installed, install it.
	if ( ! file_exists( WP_PLUGIN_DIR . '/newsletter-optin-box/noptin.php' ) ) {

		$plugin_zip = esc_url( 'https://downloads.wordpress.org/plugin/newsletter-optin-box.latest-stable.zip' );
		$upgrader   = new Plugin_Upgrader( new Automatic_Upgrader_Skin() );
		$installed  = $upgrader->install( $plugin_zip );

		if ( is_wp_error( $installed ) ) {
			error_log( (string) $upgrader->skin->get_upgrade_messages() ); // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
		}
	}

	// Activate the plugin.
	if ( file_exists( WP_PLUGIN_DIR . '/newsletter-optin-box/noptin.php' ) ) {
		activate_plugin( WP_PLUGIN_DIR . '/newsletter-optin-box/noptin.php', '', false, true );
		wp_safe_redirect( admin_url( 'admin.php?page=noptin-settings' ) );
		exit;
	}
}
add_action( 'admin_init', 'noptin_addons_pack_maybe_install_noptin' );
