<?php

namespace Noptin\Addons_Pack\Webhooks;

/**
 * Send a receive webhooks when something happens in Noptin.
 *
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Send a receive webhooks when something happens in Noptin.
 *
 */
class Main {

	/**
	 * Stores the main component instance.
	 *
	 * @access private
	 * @var    Main $instance The main component instance.
	 * @since  1.0.0
	 */
	private static $instance = null;

	/**
	 * Get active instance
	 *
	 * @access public
	 * @since  1.0.0
	 * @return Main The main component instance.
	 */
	public static function instance() {

		if ( empty( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Class Constructor.
	 */
	private function __construct() {
		add_filter( 'noptin_automation_rules_load', array( $this, 'load_triggers_and_actions' ) );
	}

	/**
	 * Loads automation rule triggers.
	 *
	 * @param \Noptin_Automation_Rules $rules
	 */
	public function load_triggers_and_actions( $rules ) {
        $rules->add_trigger( new Trigger() );
        $rules->add_action( new Action() );
	}
}
