<?php

	defined( 'ABSPATH' ) || exit;

	// fake post to prevent notices in wp_enqueue_scripts call
	$GLOBALS['post'] = new WP_Post( (object) array( 'filter' => 'raw' ) ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited

	$form = empty( $_GET['nv'] ) ? 0 : absint( $_GET['nv'] );

	if ( empty( $form ) ) {
		wp_die( esc_html__( 'Form not found', 'noptin-addons-pack' ) );
	}

	$form = noptin_get_optin_form( $form );

	// Can it be displayed?
	if ( ! $form->exists() || ! $form->is_published() ) {
		wp_die( esc_html__( 'Invalid form', 'noptin-addons-pack' ) );
	}

	// phpcs:disable WordPress.WP.EnqueuedResources.NonEnqueuedStylesheet
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>

	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link type="text/css" rel="stylesheet" href="<?php echo esc_html( bloginfo( 'stylesheet_url' ) ); ?>" />
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<meta name="robots" content="noindex, nofollow" />
		<title>Noptin Newsletter</title>
		<?php
			wp_enqueue_scripts();
			wp_print_styles();
			wp_print_head_scripts();
			wp_custom_css_cb();
		?>
		<style type="text/css">
			.noptin-actions-page{ 
				background: white;
				width: 100%;
				max-width: 100%;
				text-align: left;
				box-sizing: border-box;
			}

			html, #noptin-actions-page, #page, #content {
				padding: 0 !important;
				margin: 0 !important;
			}

			/* hide all other elements */
			#noptin-actions-page::before,
			#noptin-actions-page::after,
			#noptin-actions-page > *:not(#noptin-form-embed) { 
				display:none !important; 
			}

			#noptin-form-embed {
				display: block !important;
				width: 100%;
				height: 100%;
				padding: 20px;
				border: 0;
				margin: 0;
				box-sizing: border-box;
			}

			#noptin-form-embed form {
				margin: 1em auto;
			}
		</style>
	</head>

	<body class="noptin-actions-page page-template-default page" id="noptin-actions-page">
		<div id="noptin-form-embed" class="page type-page status-publish hentry post post-content">
			<?php $form->display(); ?>
		</div>
		<?php wp_footer(); ?>
	</body>
</html>
