<?php

namespace Noptin\Addons_Pack\WooCommerce;

/**
 * Handles WooCommerce integration.
 *
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Handles WooCommerce integration.
 *
 */
class Main {

	/**
	 * Stores the main component instance.
	 *
	 * @access private
	 * @var    Main $instance The main component instance.
	 * @since  1.0.0
	 */
	private static $instance = null;

	/**
	 * Get active instance
	 *
	 * @access public
	 * @since  1.0.0
	 * @return Main The main component instance.
	 */
	public static function instance() {

		if ( empty( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Class Constructor.
	 */
	private function __construct() {
		add_filter( 'noptin_bulk_email_senders', array( $this, 'register_sender' ) );
		add_action( 'noptin_prepare_test_data', array( $this, 'prepare_test_data' ), 10, 2 );
	}

	/**
	 * Registers the WC email sender.
	 *
	 * @param array $senders
	 */
	public function register_sender( $senders ) {

		return array_merge(
			$senders,
			array(
				'woocommerce_customers' => '\Noptin\Addons_Pack\WooCommerce\Email_Sender_Customers',
			)
		);
	}

	/**
	 * Prepares test data.
	 *
	 * @param string $email_type
	 * @param \Noptin_Newsletter_Email|\Noptin_Automated_Email $email
	 */
	public function prepare_test_data( $email_type, $email ) {

		if ( $email->is_mass_mail() && 'woocommerce_customers' === $email->get_sender() ) {

			/**@var \Noptin_WooCommerce_Lifetime_Value_Email */
			$helper = noptin()->emails->automated_email_types->types['woocommerce_lifetime_value'];

			// Try using current customer and fallback to random customer.
			$customer = new \WC_Customer( get_current_user_id() );
			if ( $customer->get_id() ) {
				$helper->customer = $customer;
			} else {
				$helper->_prepare_test_data();
			}

			$helper->prepare_customer( $helper->customer );
		}
	}
}
