<?php

namespace Stratum_Menu;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Instruction {
	private static $instance = null;

	public static function get_instance()
	{
		if (self::$instance == null)
		{
			self::$instance = new Instruction();
		}
		return self::$instance;
	}

	public function instruction_page() {
		?>
			<div class="wrap">
				<div class="stratum-instructions">
					<h2><?php esc_html_e( 'How to create a mega menu with the Stratum Mega Menu plugin?', 'stratum-menu' ); ?></h2>
					<ol class="stratum-instructions-list">
						<li> <?php esc_html_e( 'Go to your Dashboard > Appearance > Menus.', 'stratum-menu' ); ?> </li>
						<li> <?php esc_html_e( 'Select the current menu or create a new one.', 'stratum-menu' ); ?> </li>
						<li> <?php esc_html_e( 'Select and add the pages, posts, categories, etc. that will appear in your menu.', 'stratum-menu' ); ?> </li>
						<li> <?php esc_html_e( 'Open the menu item you added to your menu via the Menu Structure (expand the needed item).', 'stratum-menu' ); ?> </li>
						<li> <?php esc_html_e( 'For each menu item, you’ll see the ability to add a badge, icon, choose a unique color for your element, and more.', 'stratum-menu' ); ?> </li>
						<li> <?php esc_html_e( 'To create a mega menu, tick the Enable Mega Menu box and click the Edit Mega Menu button.', 'stratum-menu' ); ?> </li>
						<li> <?php esc_html_e( 'You’ll see the default Elementor interface, where you can add any Elementor widgets in order to create a custom mega menu.', 'stratum-menu' ); ?> </li>
						<li> <?php esc_html_e( 'Start with the Section widget - set the section background color and organize columns. To create vertical menus, use the Plain Menu widget.', 'stratum-menu' ); ?> </li>
						<li> <?php esc_html_e( 'When finished, make sure to save the changes by clicking the Save Menu button.', 'stratum-menu' ); ?> </li>
						<li> <?php esc_html_e( 'Go to your Dashboard > Pages and open the needed page.', 'stratum-menu' ); ?><br />
							<p class="description">
							<?php esc_html_e( 'If you want to replace the default theme navigation menu with your custom mega menu, make sure that you use the appropriate page template (Page Attributes > Template) that doesn’t display a built-in theme menu by default. For example, in most cases, the Elementor Canvas template is a solution.', 'stratum-menu'  ); ?>
							</p>
						</li>
						<li> <?php esc_html_e( 'Click on the Edit with Elementor button and find the Mega Menu widget. Drag it to the page and select the name of the menu you just created in the Select Menu drop-down. Customize your menu.', 'stratum-menu' ); ?> </li>
					</ol>
				</div>
			</div>
		<?php
	}
}
